({
    buildUtilityObject: function(module_name) {
        // build object
        const obj = {'view': {}, 'toast': {}, 'url': {}};
        obj['url'].argument = this.getUrlArgument.bind(this);
        obj['url'].navigate = (arg) => {
            const ev = $A.get('e.force:navigateToURL');
            if (arg && typeof arg === 'object') {
                ev.setParams(arg);
            } else if (arg && typeof arg === 'string') {
                ev.setParams({'url': arg});
            }
            ev.fire();
        }
    	obj['url'].navigateSObject = (arg) => {
            const ev = $A.get('e.force:navigateToSObject');
            if (arg && typeof arg === 'object') {
                ev.setParams(arg);
            } else if (arg && typeof arg === 'string') {
                ev.setParams({'recordId': arg});
            }
            ev.fire();
        }
        obj['invokeRemoteAction'] = this.invokeRemoteAction.bind(this);
        obj['view'].refresh = () => {
            $A.get('e.force:refreshView').fire();
        }
        obj['toast'] = this.getToaster();
        obj['log'] = this.getLogger(module_name);
		return obj;
    }, 
	getLogger: function(module_name) {
        // close over helper
        const helper = this;
		
        // define log levels
        const NONE = 0;
        const ERROR = 5;
        const WARNING = 4;
        const INFO = 3;
        const DEBUG = 2;
        const TRACE = 1;
        
        // utility methods
        const logLevel = (function(location) {
            const strLevel = helper.getUrlArgument('sflcll');
            if (strLevel === "trace") return TRACE;
            if (strLevel === "debug") return DEBUG;
            if (strLevel === "info") return INFO;
            if (strLevel === "warning") return WARNING;
            if (strLevel === "error") return ERROR;
            return NONE;
        })(document.location);
        const logCmps = (function(location) {
            const cmps = helper.getUrlArgument('sflccmps');
            if (!cmps) return undefined;
            const result = cmps.split(',');
            result.forEach((x, idx, arr) => arr[idx] = x.toLowerCase());
            return result;
        })(document.location);
        const buildLogMessage = function(name, level, msg) {
            let str = "%c[";
            switch (level) {
                case TRACE:
                    str	+= "TRACE";
                    break;
                case DEBUG:
                    str	+= "DEBUG";
                    break;
                case INFO:
                    str	+= "INFO";
                    break;
                case WARNING:
                    str	+= "WARNING";
                    break;
                case ERROR:
                    str	+= "ERROR";
                    break;
                default:
                    str += "!!UNKNOWN!!";
            }
            if (name) {
                str += '] %c[' + name + ']';
            } else {
                str += '] %c';
            }
            return str + "%c: " + (typeof msg === 'object' ? JSON.stringify(msg) : msg);
        }
			
        var Logger = function(module) {
            this._name = module;
        }
        Logger.prototype.log = function(level, msg) {
            if (logLevel === NONE) return;
            if (level < logLevel) return;
            if (logCmps && logCmps.indexOf(this._name.toLowerCase()) < 0) return;
            const logMsg = buildLogMessage(this._name, level, msg);
            
            //  slice'n'dice args
            const objs = arguments[2] && arguments[2].length ? (arguments[2].length === 1 ? arguments[2][0] : arguments[2]) : undefined;
            
            // log
            if (objs) {
                console.log(logMsg, "color:blue", "color:green", "color:black", objs);
            } else {
                console.log(logMsg, "color:blue", "color:green", "color:black");
            }
        }
        Logger.prototype.trace = function() {
            this.log(TRACE, arguments[0], Array.prototype.slice.call(arguments, 1));
        }
        Logger.prototype.debug = function() {
            this.log(DEBUG, arguments[0], Array.prototype.slice.call(arguments, 1));
        }
		Logger.prototype.info = function() {
            this.log(INFO, arguments[0], Array.prototype.slice.call(arguments, 1));
        }
		Logger.prototype.warning = function() {
            this.log(WARNING, arguments[0], Array.prototype.slice.call(arguments, 1));
        }
		Logger.prototype.error = function() {
            this.log(ERROR, arguments[0], Array.prototype.slice.call(arguments, 1));
        }
        return new Logger(module_name);
	},
    getToaster: function() {
        const helper = this;
        const showit = function(type, title, message, args) {
            const toastEvent = $A.get("e.force:showToast");
            const params = {
                'title': title || '',
                'type': type || 'info', 
                'message': message || '',
                'mode': 'dismissible'
            } 
            if (args) {
                helper.logger.trace('Looking for mode arg', args);
                if (args.mode) {
                    if (typeof args.mode === 'string' && ['dismissible','pester','sticky'].includes(args.mode)) {
                        params.mode = args.mode;
                    } else {
                        helper.logger.warning('Ignoring toast argument "mode" - not allowable value or not string');
                    }
                }
                helper.logger.trace('Looking for duration arg', args);
                if (args.duration) {
                    if (typeof args.duration === 'number') {
                        params.duration = args.duration;
                    } else {
                        helper.logger.warning('Ignoring toast argument "duration" - not a number')
                    }
                }
                helper.logger.trace('Looking for sticky arg', args);
                if (args.hasOwnProperty('sticky') && typeof args.sticky === 'boolean') {
                    helper.logger.trace('Found sticky=true argument - setting mode to sticky');
                    params.mode = 'sticky';
                }
            }
            toastEvent.setParams(params);
            toastEvent.fire();            
        }
        return {
            error: function(title, message, args) {
                showit("error", title, message, args && typeof args === 'object' ? args : undefined);
            },
            info: function(title, message, args) {
                showit("info", title, message, args && typeof args === 'object' ? args : undefined);
            },
            success: function(title, message, args) {
                showit("success", title, message, args && typeof args === 'object' ? args : undefined);
            }
        }
    },
    getUrlArgument: function(key) {
        if (!location || !location.hash) return undefined;
        const idx = location.hash.indexOf("?");
        if (idx < 0) return undefined;
        const qsCmps = location.hash.substring(idx+1).split("&");
        for (let i=0; i<qsCmps.length; i++) {
            if (qsCmps[i].toLowerCase().indexOf(key.toLowerCase() + "=") === 0) {
                const val = decodeURIComponent(qsCmps[i].substring(key.length + 1));
                return val;
            }
        }
        return undefined;
    },
    invokeRemoteAction: function() {
        if (arguments.length < 2) throw new Error('Must supply at least component and remote method name to invoke');
        const component = arguments[0];
        const method_name = arguments[1];
        const params = arguments.length >=3 && typeof arguments[2] === 'object' ? arguments[2] : undefined;
        const callback = arguments.length >= 3 && typeof arguments[arguments.length-1] === 'function' ? arguments[arguments.length-1] : () => {};
        const action = component.get(method_name.indexOf('c.') === 0 ? method_name : 'c.' + method_name);
        if (params) action.setParams(params);
		action.setCallback(this, function(response) {
        	if (response.getState() === 'SUCCESS') {
            	callback(undefined, response.getReturnValue());
			} else {
				callback(response.getError()[0].message);
			}
		});
        $A.enqueueAction(action);
    }
})